/**
 * 
 */
package com.ejie.ab18a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab18a.model.Ab18aEstructuraOrganizativa;
import com.ejie.ab18a.model.Ab18aKomunesEntidad;
import com.ejie.ab18a.model.Ab18aKomunesMesa;
import com.ejie.ab18a.model.Ab18aKomunesOrgano;
import com.ejie.ab18a.model.Ab18aKomunesPoderAdjudicador;
import com.ejie.ab18a.utils.Ab18aConstantesSQL;
import com.ejie.ab18a.utils.Utilidades;

/**
 * @author XXXX
 * 
 */
@Repository()
@Transactional()
public class Ab18aKomunesDaoImpl implements Ab18aKomunesDao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Ab18aKomunesPoderAdjudicador> rwMapPoder = new RowMapper<Ab18aKomunesPoderAdjudicador>() {
		public Ab18aKomunesPoderAdjudicador mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ab18aKomunesPoderAdjudicador(resultSet.getString("V00IDPODERADJ"));
		}
	};

	private RowMapper<Ab18aEstructuraOrganizativa> rwMapKomunes = new RowMapper<Ab18aEstructuraOrganizativa>() {
		public Ab18aEstructuraOrganizativa mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ab18aEstructuraOrganizativa(resultSet.getString("IDPODER"), resultSet.getString("IDDEPARTAMENTO"),
					resultSet.getString("IDORGANO"), "", "");
		}
	};

	private RowMapper<Ab18aEstructuraOrganizativa> rwMapKomunesImp = new RowMapper<Ab18aEstructuraOrganizativa>() {
		public Ab18aEstructuraOrganizativa mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ab18aEstructuraOrganizativa(null, null, null, resultSet.getString("IDDEPARTAMENTO"), resultSet.getString("IDMESA"));
		}
	};

	private RowMapper<Ab18aKomunesEntidad> rwMapEntidad = new RowMapper<Ab18aKomunesEntidad>() {
		public Ab18aKomunesEntidad mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ab18aKomunesEntidad(resultSet.getString("V01IDPODERADJ"), resultSet.getString("V01IDENTIDAD"));
		}
	};

	private RowMapper<Ab18aKomunesOrgano> rwMapOrgano = new RowMapper<Ab18aKomunesOrgano>() {
		public Ab18aKomunesOrgano mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ab18aKomunesOrgano(resultSet.getString("V03IDORGANO"), resultSet.getString("V03IDENTIDAD"));
		}
	};

	private RowMapper<Ab18aKomunesMesa> rwMapMesa = new RowMapper<Ab18aKomunesMesa>() {
		public Ab18aKomunesMesa mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ab18aKomunesMesa(resultSet.getString("V04IDMESA"), resultSet.getString("V04IDENTIDAD"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab18a.dao.Ab18aKomunesDao#findPoderAdjudicador(com.ejie.ab18a
	 * .model.Ab18aKomunesPoderAdjudicador)
	 */
	@Transactional(readOnly = true)
	public Ab18aKomunesPoderAdjudicador findPoderAdjudicador(Ab18aKomunesPoderAdjudicador poderAdjudicador) {
		String query = "SELECT T00_IDPODERADJ V00IDPODERADJ FROM AB18A00V00 WHERE T00_IDPODERADJ = ?";

		List<Ab18aKomunesPoderAdjudicador> poderAdjudicadorList = this.jdbcTemplate.query(query, this.rwMapPoder, poderAdjudicador.getIdPoderAdj());
		return (Ab18aKomunesPoderAdjudicador) DataAccessUtils.uniqueResult(poderAdjudicadorList);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab18a.dao.Ab18aKomunesDao#findEntidadTramitadora(com.ejie.ab18a
	 * .model.Ab18aKomunesEntidad)
	 */
	@Transactional(readOnly = true)
	public Ab18aKomunesEntidad findEntidadTramitadora(Ab18aKomunesEntidad entidad) {
		String query = "SELECT T01_IDPODERADJ V01IDPODERADJ, T01_IDDEPARTAMENTO V01IDENTIDAD FROM AB18A01V00 WHERE T01_IDPODERADJ = ? AND T01_IDDEPARTAMENTO = ?";

		List<Ab18aKomunesEntidad> entidadList = this.jdbcTemplate.query(query, this.rwMapEntidad, entidad.getIdPoderAdj(), entidad.getIdEntidad());
		return (Ab18aKomunesEntidad) DataAccessUtils.uniqueResult(entidadList);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab18a.dao.Ab18aKomunesDao#findEntidadImpulsora(com.ejie.ab18a
	 * .model.Ab18aKomunesEntidad)
	 */
	@Transactional(readOnly = true)
	public Ab18aKomunesEntidad findEntidadImpulsora(Ab18aKomunesEntidad entidad) {
		String query = "SELECT T02_IDPODERADJ V01IDPODERADJ, T02_IDDEPARTAMENTO V01IDENTIDAD FROM AB18A02V00 WHERE T02_IDPODERADJ = ? AND T02_IDDEPARTAMENTO = ?";

		List<Ab18aKomunesEntidad> entidadList = this.jdbcTemplate.query(query, this.rwMapEntidad, entidad.getIdPoderAdj(), entidad.getIdEntidad());
		return (Ab18aKomunesEntidad) DataAccessUtils.uniqueResult(entidadList);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.ab18a.dao.Ab18aKomunesDao#findOrgano(com.ejie.ab18a.model.
	 * Ab18aKomunesOrgano)
	 */
	@Transactional(readOnly = true)
	public Ab18aKomunesOrgano findOrgano(Ab18aKomunesOrgano organo) {
		String query = "SELECT T03_IDORGANO V03IDORGANO, T03_IDDEPARTAMENTO V03IDENTIDAD FROM AB18A03V00 WHERE T03_IDORGANO = ? AND T03_IDDEPARTAMENTO = ?";

		List<Ab18aKomunesOrgano> organoList = this.jdbcTemplate.query(query, this.rwMapOrgano, organo.getIdOrgano(), organo.getIdEntidad());
		return (Ab18aKomunesOrgano) DataAccessUtils.uniqueResult(organoList);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.ab18a.dao.Ab18aKomunesDao#findMesa(com.ejie.ab18a.model.
	 * Ab18aKomunesMesa)
	 */
	@Transactional(readOnly = true)
	public Ab18aKomunesMesa findMesa(Ab18aKomunesMesa mesa) {
		String query = "SELECT T04_IDMESA V04IDMESA, T04_IDDEPARTAMETO V04IDENTIDAD FROM AB18A04V00 WHERE T04_IDMESA = ? AND T04_IDDEPARTAMETO = ?";

		List<Ab18aKomunesMesa> mesaList = this.jdbcTemplate.query(query, this.rwMapMesa, mesa.getIdMesa(), mesa.getIdEntidad());
		return (Ab18aKomunesMesa) DataAccessUtils.uniqueResult(mesaList);
	}

	@Override
	public boolean comprobarPoderEntidadOrganoCoherente(String idPoder, String idEntidadImpulsora, String idOrgano) throws Exception {
		String query = null;
		boolean idsCoherentes = false;

		try {
			query = "SELECT " + Ab18aConstantesSQL.V7909S00_IDPODERADJ_009 + " IDPODER," + Ab18aConstantesSQL.V7910S00_IDDEPARTAMETO_010
					+ " IDDEPARTAMENTO," + Ab18aConstantesSQL.V7911S00_IDORGANO_011 + " IDORGANO FROM " + Ab18aConstantesSQL.CTE_V7909T00 + ","
					+ Ab18aConstantesSQL.CTE_V7910T00 + "," + Ab18aConstantesSQL.CTE_V7911T00 + " WHERE "
					+ Ab18aConstantesSQL.V7909S00_IDPODERADJ_009 + "=?" + " AND " + Ab18aConstantesSQL.V7910S00_CODDEPARTAMENTO_010 + "=?" + " AND "
					+ Ab18aConstantesSQL.V7911S00_CODORGANO_011 + "=?" + " AND " + Ab18aConstantesSQL.V7909S00_IDPODERADJ_009 + "="
					+ Ab18aConstantesSQL.V7910S00_IDPODERADJ_010 + " AND " + Ab18aConstantesSQL.V7910S00_IDDEPARTAMETO_010 + "="
					+ Ab18aConstantesSQL.V7911S00_IDDEPARTAMENTO_011;

			List<Ab18aEstructuraOrganizativa> organoList = this.jdbcTemplate.query(query, this.rwMapKomunes, idPoder, idEntidadImpulsora, idOrgano);

			if (Utilidades.notNullAndNotEmpty(organoList)) {
				idsCoherentes = true;
			}
		} catch (Exception ex) {
			idsCoherentes = false;
			throw new Exception("Excepcion durante la comprobaci�n de la coherencia Poder-Entidad-Organo", ex);
		}

		return idsCoherentes;
	}

	@Override
	public boolean comprobarEntidadMesaCoherente(String idEntidadTramitadora, String idMesa) {

		boolean idsCoherentes = false;

		String query = "SELECT " + Ab18aConstantesSQL.V7910S00_IDDEPARTAMETO_010 + " IDDEPARTAMENTO," + Ab18aConstantesSQL.V7937S00_IDMESA_037
				+ " IDMESA FROM " + Ab18aConstantesSQL.CTE_V7910T00 + "," + Ab18aConstantesSQL.CTE_V7937T00 + " WHERE "
				+ Ab18aConstantesSQL.V7910S00_CODDEPARTAMENTO_010 + "=?" + " AND " + Ab18aConstantesSQL.V7937S00_CODMESA_037 + "=?" + " AND "
				+ Ab18aConstantesSQL.V7910S00_IDDEPARTAMETO_010 + "=" + Ab18aConstantesSQL.V7937S00_IDDEPARTAMETO_037;

		List<Ab18aEstructuraOrganizativa> organoList = this.jdbcTemplate.query(query, this.rwMapKomunesImp, idEntidadTramitadora, idMesa);

		if (Utilidades.notNullAndNotEmpty(organoList)) {
			idsCoherentes = true;
		}

		return idsCoherentes;
	}
}
